'use strict';

const _ = require('lodash');

const Cache = require('../../lib/cache');
const { buildPath, buildAjaxPath } = require('../../router/path');

class Base {
    constructor(req, res, next) {
        this._req = req;
        this._res = res;
        this._next = next;
        this._cache = new Cache(req);
    }

    get pageName() {
        throw new Error('Controller does not have property pageName');
    }

    get body() {
        return this._req.body;
    }

    get query() {
        return this._req.query;
    }

    get _currentUrl() {
        return _.get(this._req, 'locals.url');
    }

    _buildPath(...args) {
        return buildPath(this._currentUrl, ...args);
    }

    _buildAjaxPath(...args) {
        return buildAjaxPath(this._currentUrl, ...args);
    }

    _render(data) {
        return this._res.renderWithLocals(this.pageName, data);
    }

    _sendOk() {
        return this._res.sendStatus(200);
    }

    _sendJSON(json) {
        return this._res
            .status(200)
            .json(json);
    }

    _sendXML(xml) {
        return this._res
            .type('application/xml')
            .send(xml);
    }

    _extendData(data) {
        return data;
    }

    _renderError(error) {
        this._req.logger.error(error, 'Render error');

        this._res.sendStatus(404);
    }
}


module.exports = Base;
