'use strict';

const _ = require('lodash');

const Base = require('./base');

/**
 * Абстрактный класс для контроллеров, работающих со списками сущностей.
 * Предоставляет интерфейс для фильтрации объектов.
 */
class Filterable extends Base {

    /**
     * Отправляет JSON с набором объектов и параметром `more`
     * Параметр сообщает, есть ли ещё объекты
     * @param {{list: Object [], more: Boolean}} data
     * @returns {Promise<Object []>}
     * @protected
     */
    _filterList(data) {
        const filterParams = this._filterParams || [];
        const filterData = _.pick(data, filterParams);

        return this._sendJSON(filterData);
    }

    /**
     * В случае ошибки возвращается пустая коллекция объектов
     * @param {Object} error
     * @returns {Promise<Object []>}
     * @protected
     */
    _filterError(error) {
        this._req.logger.error(error, 'Filter error');

        return this._sendJSON([]);
    }
}

module.exports = Filterable;
