'use strict';

const { metrikaCounters } = require('yandex-cfg');

const Base = require('./base');

class StatisticsBase extends Base {

    /**
     * Добавляет счётчики метрики для данного раздела
     * @param {Object} data
     * @returns {Object}
     */
    _addMetrikaCounters(data) {
        const sectionCounters = metrikaCounters
            .filter(counter => counter.section === data.section);

        data.metrikaCounters = this._req.locals.metrikaCounters.concat(sectionCounters);
        data.reachSubscribe = true;

        return data;
    }
}

module.exports = StatisticsBase;
