'use strict';

const Base = require('./abstractions/base');
const CaptchaModel = require('../model/news/captcha');
const captchaOptions = require('yandex-cfg').captcha;

class Captcha extends Base {

    /**
     * Показывает каптчу
     * @returns {Promise}
     * @private
     */
    showCaptcha() {
        const type = captchaOptions.type[this._req.language] || captchaOptions.type.com;

        return new CaptchaModel()
            .generate(type)
            .then(this._res.json.bind(this._res));
    }
}

module.exports = Captcha;
