'use strict';

const _ = require('lodash');
const Promise = require('bluebird');

const { buildPath, buildAjaxPath } = require('../router/path');
const seo = require('../lib/seo');

const Order = require('../model/order');
const Agencies = require('../model/agencies');

exports.index = function (req, res) {
    const { pageName, sectionName } = req.params;
    const page = 'order';

    const attributes = {
        page,
        pageName,
        sectionName,
        countries: req.query.countries,
        cities: req.query.cities,
        services: req.query.services || []
    };
    const agencies = new Agencies(req, attributes);

    Promise
        .resolve(agencies.fetchSearch())
        .then(data => {
            attributes.agencies = data;
            const order = new Order(req, attributes);

            return order.fetch();
        })
        .then(obj => {
            const data = {
                contactPageUrl: buildPath(req.locals.url, 'contact'),
                order: obj
            };
            const seoOpts = {
                section: page,
                titleData: _.get(obj, 'page.title'),
                descriptionData: _.get(obj, 'page.description')
            };

            data.seo = seo.getSeoData(req, seoOpts);
            data.og = _.get(obj, 'page.og', {});
            data.searchUrl = buildPath(req.locals.url, 'order', pageName, 'agency');
            data.filterUrl = buildAjaxPath(req.locals.url, 'agencies-filter');
            res.renderWithLocals('order', data);
        })
        .catch(error => {
            if (error.internalCode === '301_PRE') {
                return res.redirect(301, error.redirect);
            }

            req.logger.error(error);

            res.sendStatus(404);
        });
};
