/* eslint-disable new-cap */

const Base = require('./abstractions/base');
/* eslint-disable max-len */
const ADDITIONAL_CONTENT = {
    circles: {
        logo: 'https://avatars.mds.yandex.net/get-adv/61206/2a0000017f4d14fe8eaa661199f6bc5d0461/orig'
    },
    'falling_figures': {
        logo: 'https://avatars.mds.yandex.net/get-adv/49890/2a0000017fc0e0736576a6bd9886db01c59d/orig'
    },
    lines: {
        logo: 'https://avatars.mds.yandex.net/get-adv/61206/2a0000017f4d14fe8eaa661199f6bc5d0461/orig',
        verticalView: {
            background: 'https://avatars.mds.yandex.net/get-adv/42259/2a0000017f4d1691e6d51501ee1c502c1d50/orig',
            decorativeElement: [
                '<svg width="2160" height="3840" viewBox="0 0 2160 3840" fill="none" xmlns="http://www.w3.org/2000/svg"><path stroke-dasharray="15000 15000" stroke-dashoffset="15000" d="M-223.585 2050.2C445.092 1668.68 1434.68 463.141 1148.86 -123.841C947.513 -537.355 393.918 -118.309 332.384 819.48C283.156 1569.71 448.76 1887.5 686.726 2149.01C924.692 2410.53 1432.21 2578.21 1729.79 2050.2C1928.93 1696.85 1615.03 1505.21 1374.45 1790.68C964.65 2276.94 1163.65 3262.15 2126.06 3963.65C2609.45 4315.99 3011.41 4331.96 3422.65 4315.99" stroke="url(#paint0_linear_2_233)" stroke-width="239.556"><animate attributeName="stroke-dashoffset" from="15000" to="0" dur="7s"  fill ="freeze" repeatCount="1"/></path><defs><linearGradient id="paint0_linear_2_233" x1="952.233" y1="-91.8289" x2="952.233" y2="3807.94" gradientUnits="userSpaceOnUse"><stop stop-color="#FFEC42"/><stop offset="1" stop-color="#FFB800"/></linearGradient></defs></svg>',
                '<svg width="2160" height="3840" viewBox="0 0 2160 3840" fill="none" xmlns="http://www.w3.org/2000/svg"><path stroke-dasharray="15000 15000" stroke-dashoffset="15000" d="M0 1818.21C668.677 1436.7 1658.26 231.154 1372.45 -355.828C1171.1 -769.341 617.503 -350.296 555.969 587.493C506.741 1337.72 672.345 1655.51 910.311 1917.03C1148.28 2178.54 1655.79 2346.22 1953.38 1818.21C2152.52 1464.87 1838.62 1273.22 1598.04 1558.69C1188.24 2044.95 1387.24 3030.16 2349.64 3731.66C2529.64 3922.78 3277.32 4006.97 3482.54 3880.8" stroke="#1B202B" stroke-width="19.963"><animate attributeName="stroke-dashoffset" from="15000" to="0" dur="7s"  fill ="freeze" repeatCount="1"/></path></svg>'
            ]
        },
        horizontalView: {
            background: 'https://avatars.mds.yandex.net/get-adv/995572/2a0000017f4d18239c341f84f76475873d20/orig',
            decorativeElement: [
                '<svg width="3840" height="2160" viewBox="0 0 3840 2160" fill="none" xmlns="http://www.w3.org/2000/svg"><g filter="url(#filter0_d_2_433)"><path stroke-dasharray="15000 15000" stroke-dashoffset="15000" d="M930.22 2590.48C1080.45 1831.78 816.138 287.323 182.427 118.173C-264.006 -0.988142 -310.031 695.022 361.526 1358.69C898.772 1889.63 1249.01 1972.95 1604.12 1964.32C1959.23 1955.68 2420.43 1680.65 2215.3 1107.33C2078.02 723.673 1726 835.933 1784.48 1206.4C1884.09 1837.45 2763.06 2334.5 3928.82 2065.27C4464.37 1941.59 4615.79 1609.46 4615.79 1609.46" stroke="url(#paint0_linear_2_433)" stroke-width="240.667" shape-rendering="crispEdges"><animate attributeName="stroke-dashoffset" from="15000" to="0" fill="freeze" dur="7s" repeatCount="1"/></path></g><defs><filter id="filter0_d_2_433" x="-273.077" y="-15.458" width="5002.3" height="2637.31" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"/><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/><feOffset dy="4"/><feGaussianBlur stdDeviation="2"/><feComposite in2="hardAlpha" operator="out"/><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0"/><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2_433"/><feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2_433" result="shape"/></filter><linearGradient id="paint0_linear_2_433" x1="-68.4754" y1="163.481" x2="3824.59" y2="2155.97" gradientUnits="userSpaceOnUse"><stop stop-color="#FFEC42"/><stop offset="1" stop-color="#FFB800"/></linearGradient></defs></svg>',
                '<svg width="3840" height="2160" viewBox="0 0 3840 2160" fill="none" xmlns="http://www.w3.org/2000/svg"><path stroke-dasharray="15000 15000" stroke-dashoffset="15000" d="M901.17 2268.1C1051.4 1509.4 787.088 -35.0581 153.376 -204.208C-293.056 -323.369 -339.081 372.641 332.476 1036.31C869.721 1567.25 1219.96 1650.57 1575.07 1641.93C1930.18 1633.3 2391.38 1358.26 2186.25 784.953C2048.97 401.292 1696.95 513.552 1755.43 884.024C1855.04 1515.07 2734.01 2012.12 3899.77 1742.89C4470.38 1611.11 4624.81 1224.39 4624.81 1224.39" stroke="#1B202B" stroke-width="20.0556"><animate attributeName="stroke-dashoffset" from="15000" to="0" dur="7s" fill="freeze" repeatCount="1"/></path></svg>'
            ]
        }
    },
    confetti: {
        logo: 'https://avatars.mds.yandex.net/get-adv/61206/2a0000017f4d14fe8eaa661199f6bc5d0461/orig'
    }
};

class Postcard extends Base {

    _getRandomData(contents) {
        const min = 0;
        const max = contents.length;

        const randomIndex = Math.floor(Math.random() * (max - min)) + min;

        return contents[randomIndex];
    }

    render() {
        const { postcards } = this._req.bunker;
        let content = this._getRandomData(Object.keys(postcards).map(key => {
            return postcards[key];
        }));

        content.text = content.texts && this._getRandomData(content.texts);
        content = { ...content, ...ADDITIONAL_CONTENT[content.template] };

        const data = {
            content
        };

        try {
            this._res.reactRender({ bundleName: 'postcard', data });
        } catch (error) {
            this._renderError(error);
        }
    }
}

module.exports = Postcard;
