/* eslint-disable new-cap */

const config = require('yandex-cfg');

const Base = require('./abstractions/base');

const helper = require('../lib/helper');

class Promo extends Base {
    render() {
        const { bunker, tld: currentTld, params: { slug, pageId } } = this._req;

        const promo = helper.getBunkerNode(
            currentTld,
            bunker.promos,
            {
                useRequestedTldOnly: true,
                path: pageId ? [ slug, pageId ] : [ slug ]
            }
        );

        if (!promo) {
            this._res.sendStatus(404);

            return;
        }

        const data = {
            ...promo,
            frameSrc: !pageId && `${config.promos.host}/promo/${currentTld}/${slug}/`
        };

        try {
            this._res.reactRender({ bundleName: 'promo', data });
        } catch (error) {
            this._renderError(error);
        }
    }
}

module.exports = Promo;
