const _ = require('lodash');
const Promise = require('bluebird');
const config = require('yandex-cfg');

const { getBunkerNode, getPageSlugs, getPageLevels } = require('../lib/helper');
const { getSeoData, getOgData } = require('../lib/seo');
const Base = require('./abstractions/base');
const Comments = require('../model/news/comments');
const { buildPath } = require('../router/path');

class Publishers extends Base {
    index() {
        const page = 'publishers';

        return Promise
            .props({
                newsPage: buildPath('news'),
                page
            })
            .then(this._addLevels.bind(this, true))
            .then(this._addSeoData.bind(this))
            .then(this._res.renderWithLocals.bind(this, page))
            .catch(this._renderError.bind(this));
    }

    _addLevels(isMainPage, data) {
        const publishers = getBunkerNode(this._req.tld,
            this._req.bunker.sources, 'publishers._main');

        const comments = new Comments(this._req, {
            slugs: getPageSlugs(publishers)
        });

        return _.assign({
            levels: getPageLevels(publishers,
                level => isMainPage ? !level.isPublishersLevel : level.isPublishersLevel),
            shareLevel: !isMainPage && getBunkerNode(this._req.tld,
                this._req.bunker.settings, 'share-level'),
            commentsData: comments.getCommentsDataByBlogsSlugs(),
            share: config.share
        }, data);
    }

    _addSeoData(data) {
        const seoOpts = {
            section: 'publishers',
            titleData: '',
            descriptionData: ''
        };

        return _.assign({
            seo: getSeoData(this._req, seoOpts),
            og: getOgData(this._req, seoOpts)
        }, data);
    }

    _renderError(error) {
        this._req.logger.error(error, 'Render error');

        this._res.sendStatus(404);
    }
}

module.exports = Publishers;
