'use strict';

const _ = require('lodash');
const config = require('yandex-cfg');

const Requirements = require('../model/requirements');
const seo = require('../lib/seo');

exports.page = function (req, res) {
    const requirements = new Requirements(req);
    const section = 'requirements';

    return requirements
        .fetch()
        .then(requirementsData => {
            const data = _.assign(requirementsData, {
                page: section,
                hljs: config.hljs
            });
            const seoOpts = {
                section,
                titleData: '',
                descriptionData: ''
            };
            const ownSeoData = _.get(data, 'pageInfo.seo', {});
            const seoData = seo.getSeoData(req, seoOpts);

            data.seo = {
                title: ownSeoData.title || seoData.title,
                description: ownSeoData.description || seoData.description,
                keywords: ownSeoData.keywords || seoData.keywords
            };

            res.renderWithLocals('requirements', data);
        })
        .catch(error => {
            if (error.internalCode === '301_PRE') {
                return res.redirect(301, error.redirect);
            }

            req.logger.error(error);

            res.sendStatus(404);
        });
};
