'use strict';

const _ = require('lodash');
const Promise = require('bluebird');

const Base = require('./abstractions/base');
const { getBunkerNode } = require('../lib/helper');
const seo = require('../lib/seo');

class Search extends Base {
    get pageName() {
        return 'search';
    }

    serp() {
        const { text, p, constraintid } = this._req.query;

        if (!this._req.locals.siteSearchUrl) {
            return this._renderError();
        }

        return Promise
            .resolve({
                text: _.escape(text),
                p: _.escape(p),
                constraintid: _.escape(constraintid),
                searchScriptUrl: this._buildAjaxPath('site-search.js')
            })
            .then(this._addSearchData.bind(this))
            .then(this._addMetaData.bind(this))
            .then(this._render.bind(this))
            .catch(this._renderError.bind(this));
    }

    _addSearchData(data) {
        return _.assign({
            search: getBunkerNode(
                this._req.tld,
                this._req.bunker.sources,
                { path: 'search' }
            )
        }, data);
    }

    _addMetaData(data) {
        const defaultOg = getBunkerNode(this._req.tld, this._req.bunker.settings, {
            path: 'og'
        });
        const metaData = seo.getSeoData(this._req, {
            section: 'search',
            titleData: data.text,
            descriptionData: data.text
        });

        return _.assign({
            og: _.assignIn(metaData, { image: defaultOg.image }),
            seo: metaData
        }, data);
    }
}

module.exports = Search;
