/* eslint-disable new-cap */

const config = require('yandex-cfg');

const Base = require('./abstractions/base');

const helper = require('../lib/helper');
const { SegmentsComparison } = require('../lib/statvalue');

class Statvalue extends Base {
    render() {
        const { bunker, locals, tld: currentTld } = this._req;

        const {
            calculator,
            og,
            popup,
            published,
            texts,
            seo,
            survey,
            tlds
        } = helper.getBunkerNode(currentTld, bunker.statvalue);

        if (!tlds.includes(currentTld)) {
            this._res.sendStatus(404);

            return;
        }

        const domains = tlds.reduce((acc, tld) => ({
            ...acc,
            [tld]: {
                href: helper.getTldBasePath(tld, 'statvalue'),
                language: config.tldToLang[tld]
            }
        }), {});

        const data = {
            calculator,
            commonData: {
                language: locals.language,
                mordaHost: config.statvalue.mordaHost,
                secretKey: locals.secretKey,
                shareServices: config.shareServices[currentTld],
                formsUrl: config.forms.url
            },
            domains,
            faviconUrl: config.favicon[currentTld] || config.favicon.default,
            metrika: config.statvalue.metrika,
            og,
            popup,
            published,
            seo,
            shareScript: config.share,
            survey,
            texts,
            tld: currentTld
        };

        try {
            this._res.reactRender({ bundleName: 'statvalue', data });
        } catch (error) {
            this._renderError(error);
        }
    }

    calculate() {
        const { bunker, tld } = this._req;
        const { pValueTarget, k, segments } = this._req.body;

        const { tlds } = helper.getBunkerNode(tld, bunker.statvalue);

        if (!tlds.includes(tld)) {
            this._res.sendStatus(404);

            return;
        }

        this._req.logger.info({ pValueTarget, k, segments }, 'STATVALUE_CALCULATE');

        const comparison = new SegmentsComparison({ pValueTarget, k });

        for (const segment of segments) {
            comparison.addSegment(segment);
        }

        const result = comparison.compare();

        this._res.json(result);
    }
}

module.exports = Statvalue;
