'use strict';
const config = require('yandex-cfg');

const app = require('./app');
const logger = require('./lib/logger');

app.listen(config.server.port, error => {
    if (error) {
        logger.error(error, 'Server startup failed');

        return;
    }

    logger.info(`Server started on http://${config.server.hostname}:${config.server.port}/`);
});
