const config = require('yandex-cfg');
const url = require('url');

const { avatarSource } = config;
const avatarUrl = url.format({
    protocol: avatarSource.protocol,
    host: avatarSource.host,
    pathname: avatarSource.path
});

module.exports.getAvatarUrl = function (authorId) {
    return [avatarUrl, authorId, avatarSource.size].join('/');
};
