'use strict';

const Yabox = require('yabox');
const config = require('yandex-cfg');
const bb = new Yabox(config.blackbox);
const _ = require('lodash');
const Promise = require('bluebird');

class BlackboxUtil {
    static getUserInfo(uid, userip, tvmTicket) {
        return bb.userinfo({
            uid,
            userip,
            regname: 'yes',
            emails: 'getdefault',
            aliases: 13,
            headers: { 'X-Ya-Service-Ticket': tvmTicket }
        }).then(data => {
            return _.get(data, 'body.users');
        });
    }

    static getUsersInfo(uids, userip, tvmTicket) {
        const requests = _
            .chunk(uids, config.blackbox.maxChunkSize)
            .map(chunk => {
                const idsString = chunk.join(',');

                return BlackboxUtil.getUserInfo(idsString, userip, tvmTicket);
            });

        return Promise.all(requests)
            .then(_.flatten.bind(_));
    }
}

module.exports = BlackboxUtil;
