const bunkerToJs = require('bunker-to-js');
const config = require('yandex-cfg');
const Promise = require('bluebird');

const logger = require('./logger');

const environment = process.env.NODE_ENV || require('yandex-environment');

module.exports = function () {
    const opts = {
        api: config.bunker.api,
        project: config.bunker.project,
        version: config.bunker.version,
        updateInterval: config.bunker.updateInterval,
        directories: true,
        cashe: true,
        family: 6,
        parsers: [
            bunkerToJs.filter.hidden,
            bunkerToJs.filter.empty,
            bunkerToJs.tjson,
            bunkerToJs.json,
            bunkerToJs.cat
        ]
    };

    if (environment === 'drone') {
        return Promise.resolve(config.dashboard.settings);
    }
    opts.updateInterval = typeof opts.updateInterval === 'undefined' ? 5000 : opts.updateInterval;

    const bunker = bunkerToJs(opts);

    opts.parsers.forEach(bunker.parse.bind(bunker));

    return bunker
        .then(obj => obj['dashboard-settings'])
        .catch(err => logger.error(err));
};
