const LRU = require('lru-cache');
const config = require('yandex-cfg');

const cache = new LRU(config.cache.options);

class Cache {
    constructor(req) {
        this.req = req;
    }

    _buildKey(key) {
        return `${this.req.tld}:${key}`;
    }

    has(key) {
        return cache.has(this._buildKey(key));
    }

    get(key) {
        return cache.get(this._buildKey(key));
    }

    set(key, value, ttl) {
        return cache.set(this._buildKey(key), value, ttl);
    }

    getOrExecute(fn, key, ttl) {
        if (cache.has(key)) {
            return Promise.resolve(cache.get(key));
        }

        return fn().then(result => {
            cache.set(key, result, ttl);

            return result;
        });
    }

    companiesFilters() {
        return this.getOrExecute(
            () => this.req.backend.companiesFilters(),
            'CompaniesFilters',
            config.cache.ttl.companiesFilters
        );
    }

    companiesSlugs() {
        return this.getOrExecute(
            () => this.req.backend.companiesSlugs(),
            'CompaniesSlugs',
            config.cache.ttl.companiesSlugs
        );
    }
}

module.exports = Cache;
