class CardTypesGenerator {
    constructor(modes) {
        this._modes = modes;
        this._modeIndex = 0;
        this._modeCount = this._getCurrentMode().count;
    }

    _getCurrentMode() {
        return this._modes[this._modeIndex];
    }

    next() {
        const cardType = this._getCurrentMode().type;

        this._modeCount -= 1;

        if (this._modeCount === 0) {
            this._modeIndex = (this._modeIndex + 1) % this._modes.length;
            this._modeCount = this._getCurrentMode().count;
        }

        return cardType;
    }
}

module.exports = CardTypesGenerator;
