const _ = require('lodash');
const fs = require('fs');
const Promise = require('bluebird');
const multiparty = require('multiparty');

module.exports.parse = function (req) {
    return new Promise((resolve, reject) => {
        const form = new multiparty.Form();

        form.parse(req, (err, fields, files) => {
            if (err) {
                reject({ error: err });
            } else {
                fields = _.mapValues(fields, value => {
                    const [field] = value;

                    try {
                        return JSON.parse(field);
                    } catch (_error) {
                        return field;
                    }
                });

                files = _.get(files, 'list', []).map(file => ({
                    filename: file.originalFilename,
                    content: fs.createReadStream(file.path)
                }));

                resolve({ fields, files });
            }
        });
    });
};
