'use strict';

const config = require('yandex-cfg');
const url = require('url');

module.exports = function (tld, maps) {
    if (!Array.isArray(maps)) {
        return;
    }

    return maps.reduce((result, map) => {
        if (!map) {
            return result;
        }

        const tail = map.provider || 'yandex';

        result.yandex = {
            js: url.format({
                host: config.mapsApi,
                query: { lang: config.ymapsLocales[tld] || 'ru_RU' }
            }),
            tail
        };

        return result;
    }, {});
};
