'use strict';

const _ = require('lodash');

function getItemUrl(url, isCurrent, options) {
    if (!options.activeLink && isCurrent) {
        return '';
    }

    if (/^https?:\/\//.test(url)) { // FIXME: https://st.yandex-team.ru/ADVDEV-99
        return url;
    }

    return [options.root, url].join('/');
}

function buildMenuLayer(arr, result, options) {
    options = options || {};

    arr.map(item => {
        const node = {
            name: item.name,
            id: options.counter += 1,
            elem: 'leaf'
        };

        if (item.url === '/') {
            node.url = options.root;
            node.isCurrent = options.isDefault;
        } else if (item.url) {
            node.isCurrent = item.url === options.slug;
            node.url = getItemUrl(item.url, node.isCurrent, options);
        } else {
            node.elem = 'node';
            node.content = [];
        }

        if (item.items) {
            buildMenuLayer(item.items, node.content, options);
        }

        result.push(node);
    });
}

module.exports = function (arr, options) {
    const result = [];
    const counter = 1;

    buildMenuLayer(arr, result, _.extend(options, { counter }));

    return result;
};
