/* eslint-disable max-params */

const url = require('url');
const _ = require('lodash');
const { removeLastSlash } = require('../lib/helper');

const getUrl = function (urlChain, item) {
    if (!item.name) {
        return urlChain;
    }

    return `${urlChain || ''}/${item.name}`;
};

const assembleUrl = function (menuItem, urlChain) {
    return menuItem.url || getUrl(urlChain, menuItem);
};

const assembleItem = function (menuItem, items, urlChain, hasLinkInside) {
    const resultMenuItem = {
        title: menuItem.title,
        switchToSectionPage: menuItem.switchToSectionPage,
        hasChild: menuItem.hasChild
    };

    if (items.length > 0) {
        resultMenuItem.items = items;
    }

    if (hasLinkInside || menuItem.url || items.length <= 0) {
        resultMenuItem.url = assembleUrl(menuItem, urlChain);
    }

    return resultMenuItem;
};

const isSelfLink = function (menuItem, items) {
    const hasUrlProp = Boolean(menuItem.url);

    return !menuItem.name && items.length <= 0 && !hasUrlProp;
};

const getItems = function (menuItem, isPartner) {
    if (isPartner && menuItem.authItems && menuItem.authItems.length) {
        return menuItem.authItems;
    }

    return menuItem.items || [];
};

const isUrlChild = function (pathnameParts, itemUrl) {
    const parentsPathname = pathnameParts.slice(0, -1);
    const isChild = parentsPathname.join('/').startsWith(itemUrl);

    return pathnameParts.length && (isChild || isUrlChild(parentsPathname, itemUrl));
};

const areEqualUrls = function (thisUrl, thatUrl) {
    return thisUrl && thatUrl && removeLastSlash(thisUrl) === removeLastSlash(thatUrl);
};

/**
 * Маркирует пункты до текущей страницы по цепочке индексов
 * @param {Object} menu
 * @param {String []} chain
 */
const markCurrentItems = (menu, chain) => {
    let currentMenuItem = menu;
    let currentFound = false;

    chain.forEach(idx => {
        currentMenuItem.items[idx].isCurrent = true;
        currentFound = true;
        currentMenuItem = currentMenuItem.items[idx];
    });

    if (!currentFound) {
        menu.items[0].isCurrent = true;
    }
};

const prepareMenuItem = function (menuItem, isPartner, path, urlChain, indexChain) {
    const { pathname } = url.parse(path);
    const currentItems = getItems(menuItem, isPartner);
    let hasLinkInside = false;
    let currentIndexChain = null;

    /* eslint-disable complexity */
    const items = currentItems.map((childItem, index) => {
        const childChain = indexChain ? `${indexChain}.${index}` : index;
        const prepareResult = prepareMenuItem(childItem, isPartner, path,
            getUrl(urlChain, menuItem), childChain);

        if (!hasLinkInside && prepareResult.isSelfLink) {
            hasLinkInside = true;
        }

        if (!currentIndexChain && prepareResult.currentIndexChain) {
            /* eslint-disable prefer-destructuring */
            currentIndexChain = prepareResult.currentIndexChain;
        }

        return prepareResult.item;
    });
    /* eslint-enable complexity */

    const resultItem = assembleItem(menuItem, items, urlChain, hasLinkInside);

    if (!currentIndexChain) {
        const isChild = pathname && isUrlChild(pathname.split('/'), resultItem.url);

        if (areEqualUrls(resultItem.url, pathname) || isChild) {
            currentIndexChain = indexChain;
        }
    }

    return {
        item: resultItem,
        isSelfLink: isSelfLink(menuItem, items),
        currentIndexChain
    };
};

module.exports = function (mainMenu, path, isPartner, isMenuOpened) {
    const prepareResult = prepareMenuItem(_.cloneDeep(mainMenu), isPartner, path, '');
    let chain = prepareResult.currentIndexChain;

    if (typeof chain === 'number') {
        chain = chain.toString();
    }

    const indexChain = typeof chain === 'string' ? chain.split('.') : [];

    markCurrentItems(prepareResult.item, indexChain);

    return {
        item: _.assign({}, { openMenu: isMenuOpened }, prepareResult.item),
        currentIndexChain: indexChain
    };
};
