'use strict';

const _ = require('lodash');
const { buildPath } = require('../router/path');

function Price(options) {
    return _.extend({
        title: '',
        tableName: '',
        id: '',
        header: [],
        rows: [],
        information: [],
        hideTableLink: false,
        priceUrl: ''
    }, options || {});
}

/**
 * Создает таблицу в виде массивов строк.
 * @param {Array} tables
 * @param {Object} price
 * @param {String} url
 * @returns {*}
 */
module.exports.buildPrice = function (tables, price, url) {
    const table = _.find(tables, { id: price.id });

    if (!table) {
        return false;
    }

    const result = new Price({
        title: price.title,
        tableName: price.table_name,
        id: price.id,
        information: price.information,
        hideTableLink: price.hideTableLink,
        priceUrl: buildPath(url, 'prices-common')
    });

    // Находим нужные колонки в `table` и запоминаем их индексы
    const colIndexes = _.reduce(table.cols, (res, col, index) => {
        const colIdx = price.cols.indexOf(col.id);

        if (colIdx > -1) {
            res[colIdx] = index;
            result.header[colIdx] = table.cols[index];
        }

        return res;
    }, []);

    // Создаем массив строк, выбирая только те ячейки, которые стоят на позициях из `colIndexes`
    _.forEach(price.rows, rowId => {
        const row = _.find(table.rows, { id: rowId });

        if (row) {
            result.rows.push(_.at(row.cells, colIndexes));
        }
    });

    return result;
};

module.exports.buildTable = function (table) {
    if (!table) {
        return false;
    }

    return new Price({
        header: table.cols,
        rows: (table.rows || []).map(row => row.cells)
    });
};
