'use strict';

const _ = require('lodash');
const Promise = require('bluebird');
const config = require('yandex-cfg');
const helper = require('../lib/helper');
const nodemailer = require('nodemailer');
const transporter = nodemailer.createTransport({
    host: config.mail.smtp,
    port: 25
});

/**
 * Принимает массив заполненных полей и склеивает их в html-строку.
 * @param {Array} fields - список полей с полями label и value
 * @returns {String}
 */
const fieldsToHtml = function (fields) {
    return fields.reduce((result, field) => {
        return `${result}<p><strong>${field.label}</strong><br>${field.value || '–'}</p>`;
    }, '');
};

module.exports = function (options, req) {
    const forms = helper.getBunkerNode(req.tld, req.bunker.forms);
    const letter = _.assign({
        from: {
            name: forms.sender.name,
            address: forms.sender.email
        }
    }, options);

    return new Promise((resolve, reject) => {
        transporter.sendMail({
            from: letter.from,
            to: letter.to,
            subject: letter.subject,
            bcc: letter.bcc,
            html: fieldsToHtml(letter.fields),
            headers: letter.headers,
            attachments: letter.files || []
        }, error => {
            if (error) {
                reject();
            } else {
                resolve();
            }
        });
    });
};
