'use strict';

const { getBunkerNode, replaceHtmlEntities } = require('./helper');
const striptags = require('striptags');

function template(string, data) {
    string = string || '';

    return string.replace(/{{(param)}}/g, () => data || '');
}

function getTemplateStrings(tld, bunker, section) {
    const pages = getBunkerNode(tld, bunker.seo, {
        path: 'sections'
    });

    return pages.find(page => page.id === section);
}

/* eslint-disable complexity */
module.exports.getSeoData = function (req, opts) {
    opts = opts || {};

    const templates = getTemplateStrings(req.tld, req.bunker, opts.section);
    const defaultSeo = getBunkerNode(req.tld, req.bunker.seo, {
        path: 'defaults'
    });

    if (!templates) {
        return defaultSeo;
    }

    const title = replaceHtmlEntities(
        template(templates.title, striptags(opts.titleData))
    );
    const description = replaceHtmlEntities(
        template(templates.description, striptags(opts.descriptionData))
    );

    return {
        title: title || defaultSeo.title,
        pageTitle: opts.titleData || defaultSeo.title,
        titleTemplate: templates.title,
        description: description || defaultSeo.description,
        keywords: templates.keywords || defaultSeo.keywords
    };
};

/**
 * Получает дефолтные og данные из ноды settings
 * @param {Object} req
 * @returns {*}
 */
module.exports.getCommonShareData = function (req) {
    return getBunkerNode(req.tld, req.bunker.settings, {
        path: 'og'
    });
};

/**
 * Получает og данные из ноды seo
 * @param {Object} req
 * @param {Object} opts
 * @returns {*}
 */
module.exports.getOgData = function (req, opts) {
    opts = opts || {};

    const templates = getTemplateStrings(req.tld, req.bunker, opts.section);

    if (!templates) {
        return {};
    }

    const title = template(templates.ogTitle, striptags(opts.titleData));
    const description = template(templates.ogDescription, striptags(opts.descriptionData));

    return {
        title,
        description,
        image: templates.ogImage
    };
};
