'use strict';

const _ = require('lodash');

const MAXIMUM_RANDOM_FACTOR = 10e8;
// Псевдослучайные числа, чтобы «фибоначи» начинался не с 1
// Здесь важно, чтобы числа были длиной в 9 цифр
const fibCache = [478324844, 982393755];
const fib = function (n) {
    if (fibCache[n]) {
        return fibCache[n];
    }

    const fibBefore = fib(n - 1);
    const fibBeforePrev = fib(n - 2);

    // Чтобы не иметь дела с длинной математикой ограничиваем числа
    fibCache[n] = (fibBefore + fibBeforePrev) * 16 % MAXIMUM_RANDOM_FACTOR;

    return fibCache[n];
};

const substitutionIdx = (timestamp, index, lastIndex) => {
    // К таймстемпу текущего часа мы добавляем n-е число Фибоначи
    // Чтобы разброс был сильнее полученное число разворачиваем
    let factor = (String(Number(timestamp) + fib(index)))
        .split('')
        .reverse()
        .join('');

    factor = (Number(factor)) % MAXIMUM_RANDOM_FACTOR / MAXIMUM_RANDOM_FACTOR;

    return index + Math.floor(factor * (lastIndex - index + 1));
};

/* eslint-disable complexity */
/**
 * Перемашивает массив
 * @param {Array} collection
 * @param {Number []|*} permutation
 * @returns {{collection: Array, permutation: Number []}}
 * @private
 */
module.exports = (collection, permutation) => {
    permutation = permutation || [];

    let n = Number.POSITIVE_INFINITY;
    let index = 0;
    const result = _.clone(collection);
    const { length } = result;
    const lastIndex = length - 1;

    n = Math.min(n < 0 ? 0 : (Number(n) || 0), length);

    const timestamp = Date.now();

    while (index < n) {
        const rand = permutation[index] || substitutionIdx(timestamp, index, lastIndex);
        const value = result[rand];

        result[rand] = result[index];
        result[index] = value;
        permutation[index] = rand;
        index += 1;
    }

    result.length = n;

    return { collection: result, permutation };
};
/* eslint-enable complexity */
