const config = require('yandex-cfg');
const expressBunker = require('express-bunker');
const fs = require('fs');
const path = require('path');

module.exports = function () {
    const mockedFilePath = path.join(__dirname, '/../tmp/bunker.json');

    if (config.environment === 'local' && fs.existsSync(mockedFilePath)) {
        return (req, res, next) => {
            fs.readFile(mockedFilePath, (err, data) => {
                if (err) {
                    /* eslint-disable callback-return */
                    next();
                }
                req.bunker = JSON.parse(data);

                next();
            });
        };
    }

    return expressBunker(config.bunker);
};
