const _ = require('lodash');

const asyncHandler = require('../lib/async-handler');
const Captcha = require('../model/news/captcha');

async function middleware(req, res, next) {
    const fields = _.get(req, 'formData.fields', {});
    const params = _.pick(fields, ['key', 'rep', 'hasCaptcha']);

    if (!params.hasCaptcha) {
        return next();
    }

    try {
        await new Captcha().check(params);
    } catch (error) {
        return res.status(403).send({
            internalCode: '403_CCI',
            message: 'Captcha code is incorrect'
        });
    }

    next();
}

module.exports = asyncHandler(middleware);
