const _ = require('lodash');

const asyncHandler = require('../lib/async-handler');
const checkForm = require('../lib/check-form');

async function middleware(req, res, next) {
    const fields = _.get(req, 'formData.fields', {});
    const params = getCheckContactFormParams(req, fields);

    try {
        await checkForm(params);
    } catch (error) {
        return res.status(403).send({
            internalCode: '403_IIS',
            message: 'It is spam'
        });
    }

    next();
}

/**
 * Формирование полей для проверки формы
 * @param {Object} req,
 * @param {Object} data
 * @returns {Object}
 */

function getCheckContactFormParams(req, data) {
    const formFields = _.get(data, 'form');

    let fieldIncrement = 0;
    const formParams = formFields.reduce((acc, field) => {
        // пропускаем поля-чекбоксы
        if (field.isCheckbox) {
            return acc;
        }

        let fieldName = '';

        if (field.name) {
            fieldName = `so_${field.name}`;
        } else {
            // Если из формы не пришло имя поля – формируем имена вида so_field_0, so_field_1
            fieldName = `so_field_${fieldIncrement}`;
            fieldIncrement += 1;
        }

        acc[fieldName] = field.value || '';

        return acc;
    }, {});

    /* eslint-disable camelcase */
    return Object.assign({
        so_ip: _.get(req, ['headers', 'x-forwarded-for']) || _.get(req, 'connection.remoteAddress'),
        so_host: req.hostname,
        so_realpath: _.get(req, 'headers.referer'),
        so_service: 'ADV',
        so_form_name: data.formName
    }, formParams);
    /* eslint-enable camelcase */
}

module.exports = asyncHandler(middleware);
