const Typer = require('bundle-typer');
const path = require('path');

const AdvTyper = function (...args) {
    /* eslint-disable new-cap */
    Typer.apply(this, args);
};

AdvTyper.prototype = Object.create(Typer.prototype);
AdvTyper.prototype.get = function (bundleName) {
    // Что здесь происходит
    // Мы намеренно заворачиваем все шаблоны в common кроме главной страницы
    const bundle = bundleName === 'index' ? bundleName : 'common';
    const result = Typer.prototype.get.call(this, bundle);

    // Но при этом в priv у нас должен вызываться
    // b-page_type_<имя бандла>
    result.name = path.basename(bundleName);

    return result;
};

module.exports = function (opts) {
    opts = opts || {};
    opts.cwd = opts.cwd || 'static';
    opts.lang = opts.lang || 'ru';
    opts.block = opts.block || 'page';

    return function (req, res, next) {
        res.bundleRender = function bundleRender(bundleName, data, bundlePlatform) {
            const bundle = new AdvTyper(opts);

            bundle
                .lang(req.language)
                .type(bundlePlatform);

            data.bundlePlatform = bundlePlatform;
            // Callback mode gives +15k rps
            AdvTyper.prototype.render.call(bundle, bundleName, data, (err, html) => {
                if (err) {
                    return res.emit('error', err);
                }

                res.send(html);
            });
        };

        next();
    };
};
