const fs = require('fs');

const _ = require('lodash');
const multiparty = require('multiparty');

module.exports = function (req, res, next) {
    const form = new multiparty.Form();

    form.parse(req, (error, fields, files) => {
        if (error) {
            req.logger.error(error, 'Can not parse form');

            return res
                .status(503)
                .send({
                    internalCode: '503_MNS',
                    message: 'Message not sent'
                });
        }

        fields = _.mapValues(fields, value => {
            const [field] = value;

            try {
                return JSON.parse(field);
            } catch (_error) {
                return field;
            }
        });

        files = _.get(files, 'list', []).map(file => ({
            filename: file.originalFilename,
            content: fs.createReadStream(file.path)
        }));


        req.formData = { fields, files };

        next();
    });
};
