const _ = require('lodash');
const config = require('yandex-cfg');
const fs = require('fs');
const path = require('path');

module.exports = function () {
    const mockedFilePath = path.join(__dirname, '/../tmp/advertising-www.json');

    if (!fs.existsSync(mockedFilePath)) {
        return (req, res, next) => next();
    }

    return (req, res, next) => {
        fs.readFile(mockedFilePath, (err, data) => {
            if (err) {
                /* eslint-disable callback-return */
                next();
            }

            const translations = JSON.parse(data);
            const local = _.get(translations, req.language, translations[config.i18n.default]);

            req.i18n = (keyset, key) => _.get(local, [keyset, key]);

            next();
        });
    };
};
