'use strict';

const _ = require('lodash');
const config = require('yandex-cfg');
const menuPrepare = require('../lib/menu-prepare');
const helper = require('../lib/helper');

function getAdditionalBreadcrumbs(locals, bunker) {
    const additionalBreadcrumbs = helper
        .getBunkerNode(locals.tld, bunker.menu['additional-breadcrumbs']);
    const currentPath = helper.removeLastSlash(locals.currentPath);

    return _(additionalBreadcrumbs)
        .filter(rule => new RegExp(rule.mask).test(currentPath))
        .map('breadcrumbs')
        .flatten()
        .value();
}

module.exports = (req, res, next) => {
    let path = req.originalUrl;

    if (!req.locals.url.startsWith(config.host)) {
        path = path.replace(/^\/adv/, '');
    }

    const menuPrepareResult = menuPrepare(
        helper.getBunkerNode(req.locals.tld, req.bunker.menu['main-menu']),
        helper.removeLastSlash(path),
        req.partnersAccess === 'allowed',
        req.query.menu === 'open'
    );
    const breadcrumbs = getAdditionalBreadcrumbs(req.locals, req.bunker);

    req.locals.mainMenu = menuPrepareResult.item;
    req.locals.mainMenu.additionalBreadcrumbs = breadcrumbs;
    req.locals.breadcrumbsChain = menuPrepareResult.currentIndexChain;

    next();
};
