const url = require('url');

const _ = require('lodash');
const config = require('yandex-cfg');
const got = require('got');

const asyncHandler = require('../lib/async-handler');

const directApiBaseUrl = url.format(config.direct);
const directBaseOptions = {
    method: 'GET',
    json: true,
    timeout: config.direct.timeout
};

async function middleware(req, res, next) {
    const { userInfo } = req.locals;

    if (!userInfo.isAuthorized) {
        req.partnersAccess = 'forbidden';
        next();

        return;
    }

    const { uid } = userInfo;
    const tvmTicket = _.get(req, 'tvm.tickets.direct.ticket');
    const options = {
        ...directBaseOptions,
        query: { uid },
        headers: { 'x-ya-service-ticket': tvmTicket }
    };

    try {
        const { body: { role } } = await got(directApiBaseUrl, options);

        req.partnersRole = role;
        req.partnersAccess = config.partnersAccessRoles.includes(role) ? 'allowed' : 'invalid';
    } catch (error) {
        req.logger.error(error, `Partner access error (uid=${uid})`);

        req.partnersAccess = 'forbidden';
    }

    next();
}

module.exports = asyncHandler(middleware);
