const webpack = require('webpack');
const devMiddleware = require('webpack-dev-middleware');
const hotMiddleware = require('webpack-hot-middleware');

const webpackConfigs = require('../../../webpack/client.config');

const render = require('./render');

function getWebpackMiddlewares(config, index) {
    const compiler = webpack({ ...config, mode: 'development' });

    return [
        devMiddleware(compiler, {
            logLevel: 'error',
            publicPath: config.output.publicPath
        }),
        hotMiddleware(compiler, { path: `/__webpack_hmr_${index}` })
    ];
}

module.exports = [
    ...webpackConfigs.reduce((middlewares, config, index) => [
        ...middlewares,
        ...getWebpackMiddlewares(config, index)
    ], []),
    render
];
