const renderBundle = require('./render-bundle');

module.exports = (req, res, next) => {
    res.renderBundle = (bundleName, data, state) => {
        const { language, url: location } = req;
        const { html, redirectUrl } = renderBundle({ bundleName, data, state, language, location });

        if (redirectUrl) {
            res.redirect(redirectUrl);

            return;
        }

        res.send(html);
    };

    next();
};
