'use strict';

const config = require('yandex-cfg');

module.exports = function (section) {
    return function (req, res, next) {
        req.regions = config.regionsOrder.reduce((result, regionId) => {
            result[regionId] = { path: section };

            return result;
        }, {});

        if (section === 'contact') {
            req.regionsOrder = config.agenciesRegionsOrder;
        }
        next();
    };
};
