'use strict';

const url = require('url');

const TRUSTED_HOSTS = [
    /^([^/]+\.)?webvisor\.com$/i
];

module.exports = (req, res, next) => {
    const refererHostname = url.parse(req.headers.referer || '').hostname;

    if (TRUSTED_HOSTS.every(item => !item.test(refererHostname))) {
        res.setHeader('X-Frame-Options', 'SAMEORIGIN');
    }

    next();
};
