'use strict';

const bunkerToJs = require('bunker-to-js');
const config = require('yandex-cfg');
const fs = require('fs');
const path = require('path');

const start = Date.now();
const parsers = [
    bunkerToJs.filter.hidden,
    bunkerToJs.filter.empty,
    bunkerToJs.avatar,
    bunkerToJs.tjson,
    bunkerToJs.json,
    bunkerToJs.cat
];

console.log('Parsing...');

const request = function (retries) {
    const bunker = bunkerToJs(Object.assign({}, config.bunker, { parsers }));

    parsers.forEach(bunker.parse.bind(bunker));

    return bunker
        .then()
        .catch(err => {
            if (retries <= 0) {
                throw err;
            }
            console.error('\x1b[31mRetry\x1b[0m');

            return request(retries - 1);
        });
};

request(5)
    .then(obj => {
        const [,, dir] = process.argv;

        if (!fs.existsSync(dir)) {
            fs.mkdirSync(dir);
        }

        const tmp = path.join(dir, 'bunker.json');

        fs.writeFile(tmp, JSON.stringify(obj, null, '  '), err => {
            if (err) {
                return console.log('\x1b[31m', err, '\x1b[0m');
            }
            console.log('\x1b[32m', `✓ The file was saved! \x1b[34m${Date.now() - start}ms\x1b[0m`);
        });
    })
    .catch(err => {
        console.error('\x1b[31m', err, '\x1b[0m');
    });
