'use strict';

const _ = require('lodash');
const { buildPath, buildAjaxPath } = require('../../router/path');

class Base {
    constructor(req, attributes = {}) {
        this._req = req;
        this._bunker = req.bunker;
        this._attributes = attributes;
    }

    get _currentUrl() {
        return _.get(this._req, 'locals.url');
    }

    _parseData(data) {
        return data;
    }

    _reject(internalError) {
        return Promise.reject(internalError);
    }

    _buildPath(...args) {
        return buildPath(this._currentUrl, ...args);
    }

    _buildAjaxPath(...args) {
        return buildAjaxPath(this._currentUrl, ...args);
    }

    _checkRedirect(pageData) {
        if (pageData.redirect) {
            return Promise.reject({
                internalCode: '301_PRE',
                message: 'Redirect enabled',
                redirect: pageData.redirect
            });
        }

        return Promise.reject({
            internalCode: '404_PNE',
            message: 'Page not enabled'
        });
    }
}

module.exports = Base;
