'use strict';

const _ = require('lodash');
const { getDate } = require('../../lib/helper');

const Base = require('../abstractions/base');

class EduBase extends Base {

    /**
     * Проверяет событие на актуальность (по дате)
     * @param {Object} event
     * @returns {Boolean}
     */
    _isActualEvent(event) {
        if (!event || !_.get(event, 'enabled')) {
            return false;
        }

        const eventDate = getDate(_.get(event, 'end.date') || _.get(event, 'start.date'));

        // Cобытие считается актуальным в последний день своей актуальности
        eventDate.setDate(eventDate.getDate() + 1);

        return eventDate > new Date();
    }
}

module.exports = EduBase;
