'use strict';

const _ = require('lodash');
const Base = require('../abstractions/base');
const Promise = require('bluebird');

class OnlineServices extends Base {
    fetch() {
        const { tld } = this._req;

        return Promise.resolve(this._bunker['online-edu-services'][tld])
            .bind(this)
            .then(this._parseData);
    }

    _parseData(data) {
        return _(data)
            .values()
            .value();
    }
}

module.exports = OnlineServices;
