'use strict';

const ExpressCaptcha = require('express-captcha/lib/captcha');
const captchaParams = require('yandex-cfg').captcha;
const captcha = new ExpressCaptcha(captchaParams);

class Captcha {

    /**
     * Генерирует каптчу
     * @param {String} type
     * @returns {Promise}
     */
    generate(type) {
        return captcha.generate(type);
    }

    /**
     * Проверяет каптчу
     * @param {Object} params
     * @returns {Promise}
     */
    check(params) {
        return captcha.check(params);
    }
}

module.exports = Captcha;
