'use strict';

const url = require('url');
const path = require('path');

const NewsBase = require('./news-base');

/**
 * Модель для получения данных о категориях
 */
class Categories extends NewsBase {

    /**
     * Преобразование данных модели после получения с сервера
     * @returns {Categories}
     * @private
     */
    _parseData() {
        this._data.forEach(category => {
            category.url = url.format({
                query: {
                    categoryId: category._id
                }
            });
        });

        return this._data;
    }

    /**
     * Получить список категорий
     *
     * @returns {Categories}
     */
    fetch() {
        const options = {
            url: path.join('/categories/all', this._attributes.blogIdentity),
            query: this._attributes.query
        };

        return this._request(options)
            .catch(error => {
                this._req.logger.error(error);
            });
    }
}

module.exports = Categories;
