'use strict';

const _ = require('lodash');
const NewsBase = require('./news-base');
const path = require('path');

/**
 * Модель для получения данных о посте
 */
class Post extends NewsBase {

    /**
     * Преобразование данных модели после получения с сервера
     * @returns {{ item: Post, isPumpkinResponse: boolean }}
     * @private
     */
    _parseData() {
        const item = _(this._data)
            .pick([
                '_id',
                'publishDate',
                'modificationDate',
                'approvedTitle',
                'approvedBody',
                'tags',
                'approvedPreview',
                'titleImage',
                'socialImage',
                'authorId',
                'slug',
                'canComment',
                'isOutdated',
                'commentsEnabled',
                'relatedTitle',
                'categoryIds',
                'viewType'
            ])
            .value();

        return { item, isPumpkinResponse: this._isPumpkinResponse };
    }

    /**
     * Получить пост
     *
     * @returns {Post}
     */
    fetch() {
        const headers = this.getHeaders();
        const options = {
            url: path.join('/post', this._attributes.blogIdentity, this._attributes.postIdentity),
            query: this._attributes.query,
            headers: _.assign({
                userip: this._req.ip,
                userhost: this._req.hostname
            }, headers)
        };

        return this._request(options);
    }

    _onResponse(data) {
        super._onResponse(data);

        this._isPumpkinResponse = Boolean(data.headers['x-is-pumpkin-response']);

        return this;
    }

    static unwrap(obj) {
        if (_.isPlainObject(obj.post)) {
            const { item, isPumpkinResponse } = obj.post;

            obj.post = item;
            obj.isPumpkinResponse = isPumpkinResponse;
        }

        return obj;
    }
}

module.exports = Post;
