'use strict';

const path = require('path');

const _ = require('lodash');

const NewsBase = require('./news-base');
const { getBlogLang } = require('../../lib/helper');

/**
 * Модель для получения данных о связанных статьях
 */
class RelatedArticles extends NewsBase {

    /**
     * Преобразование данных модели после получения с сервера
     * @returns {RelatedArticles}
     * @private
     */
    _parseData() {
        return this._data.map(article => {
            return _(article)
                .pick([
                    'title',
                    'url'
                ])
                .value();
        });
    }

    /**
     * Получить список связанных статей
     *
     * @returns {RelatedArticles}
     */
    fetch() {
        const headers = this.getHeaders();
        const options = {
            url: path.join(
                '/post/related',
                this._attributes.blogIdentity,
                this._attributes.postIdentity
            ),
            query: {
                lang: getBlogLang(this._req.tld)
            },
            headers: _.assign({
                userip: this._req.ip,
                userhost: this._req.hostname
            }, headers)
        };

        return this
            ._request(options)
            .catch(error => {
                this._req.logger.error(error);

                return Promise.resolve([]);
            });
    }
}

module.exports = RelatedArticles;
