'use strict';

const path = require('path');

const Promise = require('bluebird');

const NewsBase = require('./news-base');

/**
 * Модель для получения данных о теге
 */
class Tag extends NewsBase {

    /**
     * Преобразование данных модели после получения с сервера
     * @returns {Tag}
     * @private
     */
    _parseData() {
        return this._data;
    }

    /**
     * Получить список тегов
     *
     * @returns {Tag}
     */
    fetch() {
        const tagSlug = this._attributes.query.tag;

        if (!tagSlug) {
            return Promise.resolve();
        }

        const options = {
            url: path.join('/tag', this._attributes.blogIdentity, encodeURIComponent(tagSlug)),
            query: this._attributes.query
        };

        return this
            ._request(options)
            .catch(error => {
                this._req.logger.error(error);
            });
    }
}

module.exports = Tag;
