'use strict';

const url = require('url');
const path = require('path');

const NewsBase = require('./news-base');

/**
 * Модель для получения данных о тегах
 */
class Tags extends NewsBase {

    /**
     * Преобразование данных модели после получения с сервера
     * @returns {Tags}
     * @private
     */
    _parseData() {
        this._data.forEach(tag => {
            tag.url = url.format({
                query: {
                    tag: tag.slug
                }
            });
        });

        return this._data;
    }

    /**
     * Получить список тегов
     *
     * @returns {Tags}
     */
    fetch() {
        const options = {
            url: path.join('/tags/all', this._attributes.blogIdentity),
            query: this._attributes.query
        };

        return this
            ._request(options)
            .catch(error => {
                this._req.logger.error(error);
            });
    }
}

module.exports = Tags;
