'use strict';

const NewsBase = require('./news-base');
const _ = require('lodash');

class User extends NewsBase {
    fetchActivity() {
        const headers = this.getHeaders();
        const options = {
            url: '/user/activity',
            method: 'GET',
            headers: Object.assign({
                userip: this._req.ip,
                userhost: this._req.hostname
            }, headers)
        };

        return this._request(options);
    }

    resetActivity() {
        const headers = this.getHeaders();
        const options = {
            url: '/user/activity',
            method: 'DELETE',
            headers: Object.assign({
                userip: this._req.ip,
                userhost: this._req.hostname
            }, headers)
        };

        return this._request(options)
            .catch(_.noop);
    }
}

module.exports = User;
