'use strict';

const Promise = require('bluebird');
const Base = require('./abstractions/base');
const _ = require('lodash');
const leftMenu = require('../lib/left-menu');
const helper = require('../lib/helper');

class Partners extends Base {
    fetch() {
        const data = this._parseData();

        return Promise.resolve(data);
    }

    /* eslint-disable complexity */
    _parseData() {
        const access = this._req.partnersAccess;
        const {
            block,
            page: slug
        } = _.pick(this._attributes, ['block', 'page']);

        const typePage = access === 'allowed' ? 'private' : 'public';
        const menu = helper.getBunkerNode(this._req.tld,
            this._bunker.menu[`partners-menu-${typePage}`]);

        const partnersPath = block ? `partners.${block}` : 'partners';

        const partners = helper.getBunkerNode(this._req.tld, this._bunker.sources, {
            path: partnersPath
        });

        if (!partners || !(slug in partners)) {
            return Promise.reject({
                internalCode: '404_PNF',
                message: 'Partners page not found'
            });
        }

        const page = partners[slug];

        if (!page.enabled) {
            return this._checkRedirect(page);
        }

        const accessPage = _.get(partners, [slug, 'type']);
        const hasAccess = accessPage === 'all' || accessPage === typePage;
        const result = {
            page: slug,
            hasAccess,
            access,
            role: this._req.partnersRole,
            menu: leftMenu(menu, {
                slug,
                root: this._buildPath('partners'),
                isDefault: page.default
            }),
            info: page,
            messages: partners.messages,
            sectionUrl: this._buildPath('partners'),
            requestPageUrl: this._buildPath('partners', 'request'),
            requestUrl: this._buildAjaxPath('partners', 'send'),
            regions: _.get(partners, 'regions', {})
        };

        if (slug === 'request') {
            result.form = helper.getBunkerNode(this._req.tld,
                this._bunker.forms,
                {
                    path: ['partners-form', 'steps']
                });

            if (!result.form) {
                return;
            }
        }

        return result;
    }
}

module.exports = Partners;
