'use strict';

const Promise = require('bluebird');
const Base = require('./abstractions/base');
const _ = require('lodash');
const leftMenu = require('../lib/left-menu');
const helper = require('../lib/helper');

/**
 * Модель раздела Технические характеристики
 */
class Requirements extends Base {
    fetch() {
        return Promise.resolve(this._parseData());
    }

    _parseData() {
        const slug = _.get(this._req.params, 'pageName');
        const menu = helper.getBunkerNode(this._req.tld, this._bunker.menu['requirements-menu']);
        const root = helper.getBunkerNode(this._req.tld, this._bunker.sources, {
            path: 'requirements'
        });
        const sectionInfo = root.info;

        // Убираем поле 'info', чтобы полями остались только дочерние ноды
        const pages = _.omit(root, 'info');
        let pageInfo = null;

        if (slug) {
            if (!(slug in pages)) {
                return Promise.reject({
                    internalCode: '404_PNF',
                    message: 'Requirements page not found'
                });
            }

            pageInfo = pages[slug];

            if (!pageInfo.enabled) {
                return this._checkRedirect(pageInfo);
            }
        }

        return {
            isMainPage: !slug,
            sectionInfo,
            pageInfo,
            menu: leftMenu(menu, { slug, root: this._buildPath('requirements') }),
            requirementsPageUrl: this._buildPath('requirements')
        };
    }
}

module.exports = Requirements;
